<?php 
/**
 * @author Luiz Lucas
 * @version 1.0
 * Arquivo com todas as rotas do site
 * 
**/
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Message\ResponseInterface;

//Página inicial
$app->get('/', function () use($twig, $db) {
    if(isset($_SESSION['usuarioLogado']) == true) {
        $Postos = $db->select('*')->from('posto')->query();
        renderizarView($twig, ['titulo' => 'Pesquisa de satisfação', 'Postos' => $Postos, 'viewport' => true], 'home');
    } else {
        renderizarView($twig, ['titulo' => 'Login', 'viewport' => true], 'login');
    }
});

//Processa login
$app->post('/login', function () use($twig, $db, $app) {
    extract($_POST);

    $Email = addslashes ( anti_injection( $_POST['email'] ) );
    $Senha = md5 ( addslashes ( anti_injection ( $_POST['senha'] ) ) );

    $Usuario = $db->select('*')->from('usuario')->where("email = '$Email' and senha = '$Senha'")->query();

    if(!empty($Usuario) AND validarUsuario($Usuario[0]) == true) {
	$app->redirect(URL);
	echo "<script>location.href='http://enquete.prolins.com.br/lmm/selecionar-posto';</script>";
    } else {
       $app->redirect(URL."/?erro=login");
    }
});

//Deslogar do sistema
$app->get('/deslogar', function () use($twig, $db) {
   finalizarSessao();
});

//Seleção do posto
$app->get('/selecionar-posto', function () use($twig, $db) {
    $Postos = $db->select('*')->from('posto')->query();
    renderizarView($twig, ['titulo' => 'Pesquisa de satisfação', 'Postos' => $Postos, 'viewport' => true], 'selecionar-posto');
});

//Processa o posto para seguir para enquete
$app->post('/processa-posto', function () use($twig, $db, $app) {
    $app->redirect(URL.'/enquete/'.$_POST['posto']."");
});

//Página da enquete
$app->get('/enquete/:posto', function ($Posto) use($twig, $db) {
    renderizarView($twig, ['titulo' => 'Pesquisa de satisfação', 'posto_id_posto' => $Posto, 'viewport' => true], 'enquete');
});

//Pagina de agradecimento
$app->get('/obrigado/:posto', function ($Posto) use($twig, $db) {
    renderizarView($twig, ['titulo' => 'Obrigado', 'posto_id_posto' => $Posto, 'viewport' => true], 'obrigado');
});

//Enviar enquete para o banco de dados
$app->post('/enviar-enquete', function () use($twig, $db, $app) {
    extract($_POST);

    //Verifica se o usuario marcou alguma das opções dos Emocticons, caso não o sistema da uma nota automaticamente.
    (!isset($satisfacao)) ? $satisfacao = 5 : $satisfacao = $satisfacao;
    (!isset($recomenda)) ? $recomenda = 1 : $recomenda = $recomenda;

    //Insert no banco
    $Enquete = $db->insert('enquete')->cols([
    	'posto_id_posto' => $posto_id_posto,
    	'acesso_localizacao' => $acesso_localizacao,
    	'estacionamento' => $estacionamento,
    	'atendimento_telefonico' => $atendimento_telefonico,
    	'atendimento_recepcao' => $atendimento_recepcao,
    	'atendimento_coleta' => $atendimento_coleta,
    	'higiene' => $higiene,
    	'conforto' => $conforto,
    	'entrega_resultados' => $entrega_resultados,
    	'satisfacao' => $satisfacao,
    	'recomenda' => $recomenda,
    	'data' => date('Y-m-d')
    ])->query();

    $Posto = $db->select('nome')->from('posto')->where("id_posto = $posto_id_posto")->query();

    //Enviar para o email
    $Mensagem = "
        Nova pesquisa preenchida! <br/>
        Data: ".date('d/m/Y')." <br/>
        <b>Posto</b>: ".utf8_decode($Posto[0]['nome'])." <br/> <br/>
        Acesso e Localização: ".verificaNA($acesso_localizacao)." <br/>
        Estacionamento: ".verificaNA($estacionamento)." <br/>
        Atendimento telefônico: ".verificaNA($atendimento_telefonico)." <br/>
        Atendimento recepção: ".verificaNA($atendimento_recepcao)." <br/>
        Atendimento coleta: ".verificaNA($atendimento_coleta)." <br/>
        Higiene: ".verificaNA($higiene)." <br/>
        Conforto: ".verificaNA($conforto)." <br/>
        Entrega de resultados: ".verificaNA($entrega_resultados)." <br/> <br/>
        Satisfação geral: ".getSatisfacao($satisfacao)." <br/>
        Recomendaria: ".getRecomenda($recomenda)."
    ";

    enviarEmail("Robô da Enquete", EMAIL_ADMIN, "Nova pesquisa preenchida", $Mensagem);

    $app->redirect(URL."/obrigado/$posto_id_posto");
});

//Página de filtros
$app->get('/gerar-relatorio', function() use($twig, $db) {
    $todosPostos = $db->select('*')->from('posto')->query();
    $InicioMes = date('d/m/Y', mktime(0, 0, 0, date('m') , 1 , date('Y')));
    $FimMes = date('d/m/Y', mktime(23, 59, 59, date('m'), date("t"), date('Y')));

    renderizarView($twig, ['titulo' => 'Gerar relatório', 'Postos' => $todosPostos, 'DataPadrao' => [$InicioMes, $FimMes], 'viewport' => true], 'filtros');
});

//Página dos relatórios
$app->post('/relatorios', function() use($twig, $db) {
    extract($_POST);
    
    $Datas = explode(' - ', $periodo);
    $Data_Inicio = gravaData($Datas[0]); $Data_Fim = gravaData($Datas[1]);

    if (!isset($postos)) {
        $postos = $db->select('id_posto')->from('posto')->query();
        
        $listaPostos = [];
        foreach ($postos as $posto) {
            $listaPostos[] = $posto['id_posto'];
        }

        $postos = implode(',', $listaPostos);
    } else {
        $postos = implode(',', array_map('intval', $postos));
    }
    
    renderizarView($twig, ['titulo' => 'Relatórios e gráficos', 'Filtros' => ['DataInicio' => $Data_Inicio, 'DataFim' => $Data_Fim , 'Postos' => $postos], 'viewport' => true], 'relatorios');
});

/* Requisições para os relatórios */

//Requisição de Avaliação dos serviços
$app->get('/requisitar-avaliacao-servicos/:DataInicio/:DataFim/:Postos', function($DataInicio, $DataFim, $Postos) use($twig, $db) {
    try {

        $rPostos = $db->query("
            SELECT AVG(NULLIF(estacionamento, 0)) as mEstacionamento, 
            AVG(NULLIF(acesso_localizacao, 0)) as mAcesso, 
            AVG(NULLIF(atendimento_telefonico, 0)) as mAtendimentoTelefonico,
            AVG(NULLIF(atendimento_recepcao, 0)) as mAtendimentoRecepcao, 
            AVG(NULLIF(atendimento_coleta, 0)) as mAtendimentoColeta, 
            AVG(NULLIF(higiene, 0)) as mHigiene,
            AVG(NULLIF(conforto, 0)) as mConforto, 
            AVG(NULLIF(entrega_resultados, 0)) as mEntrega, data
            FROM enquete WHERE data BETWEEN ('$DataInicio') AND ('$DataFim') AND posto_id_posto in ($Postos)
        ");
        
        /* AVALIAÇÃO DE SERVIÇOS */

            //Calculando o valor total das notas de cada pergunta
            foreach ($rPostos as $Posto) {
                $mAcesso = round($Posto['mAcesso'], 2);

                $mEstacionamento = round($Posto['mEstacionamento'], 2);
                
                $mAtendimentoTelefonico = round($Posto['mAtendimentoTelefonico'], 2);

                $mAtendimentoRecepcao = round($Posto['mAtendimentoRecepcao'], 2);
               
                $mAtendimentoColeta = round($Posto['mAtendimentoColeta'], 2);
                
                $mHigiene = round($Posto['mHigiene'], 2);
                
                $mConforto = round($Posto['mConforto'], 2);
                
                $mEntregaResultados = round($Posto['mEntrega'], 2);
            }

            $rArray_Avaliacao = [
                'labels' => [
                    "Acesso e Localização", 
                    "Estacionamento", 
                    "Atendimento Telefônico", 
                    "Atendimento na Recepção", 
                    "Atendimento na Coleta",  
                    "Higiene e Limpeza", 
                    "Conforto das Instalações", 
                    "Entrega de resultados"
                ],
                'datasets' => [[
                    'label' => ['# Média'],
                    'data' => [
                        $mAcesso, 
                        $mEstacionamento, 
                        $mAtendimentoTelefonico, 
                        $mAtendimentoRecepcao, 
                        $mAtendimentoColeta, 
                        $mHigiene, 
                        $mConforto, 
                        $mEntregaResultados
                    ],
                    'backgroundColor' => [
                        randomColor(),
                        randomColor(),
                        randomColor(),
                        randomColor(),
                        randomColor(),
                        randomColor(),
                        randomColor(),
                        randomColor()
                    ]
                ]]
            ];

            echo json_encode($rArray_Avaliacao);

        } catch (Exception $e) {
            echo json_encode(['Erro' => 'Relatório sem dados suficientes.']);
        }

    /* FIM DA AVALIAÇÃO DE SERVIÇOS */ 
});

//Requisição de Avaliação da satisfação
$app->get('/requisitar-satisfacao-geral/:DataInicio/:DataFim/:Postos', function($DataInicio, $DataFim, $Postos) use($twig, $db) {
    $rSatisfacao = $db->query("SELECT satisfacao, posto_id_posto, count(*) as total FROM enquete WHERE data BETWEEN ('$DataInicio') AND ('$DataFim') AND satisfacao in (1, 2, 3, 4, 5) AND posto_id_posto in ($Postos) group by satisfacao");
    
    /* SATISFAÇÃO GERAL */

        $MuitoInsatisfeito = 0;
        $Insatisfeito = 0;
        $Regular = 0;
        $Satisfeito = 0;
        $MuitoSatisfeito = 0;
        $count = 0;
        foreach ($rSatisfacao as $Satisfacao) {
            if ($Satisfacao['satisfacao'] == 1) {
                $MuitoInsatisfeito = $Satisfacao['total'];
                $count++;
            }
            if ($Satisfacao['satisfacao'] == 2) {
                $Insatisfeito = $Satisfacao['total'];
                $count++;
            }
            if ($Satisfacao['satisfacao'] == 3) {
                $Regular = $Satisfacao['total'];
                $count++;
            }
            if ($Satisfacao['satisfacao'] == 4) {
                $Satisfeito = $Satisfacao['total'];
                $count++;
            }
            if ($Satisfacao['satisfacao'] == 5) {
                $MuitoSatisfeito = $Satisfacao['total'];
                $count++;
            }
        }

        if ($count <= 2) {
            echo json_encode(['Erro' => 'Relatório sem dados suficientes.']);
        } else {

            $rArray_Satisfacao = [
                'labels' => [
                    "Muito Insatisfeito", 
                    "Insatisfeito", 
                    "Regular", 
                    "Satisfeito",
                    "Muito Satisfeito"
                ],
                'datasets' => [[
                    'data' => [
                        $MuitoInsatisfeito,
                        $Insatisfeito,
                        $Regular,
                        $Satisfeito,
                        $MuitoSatisfeito
                    ],
                    'backgroundColor' => [
                        randomColor(),
                        randomColor(),
                        randomColor(),
                        randomColor(),
                        randomColor()
                    ]
                ]]
            ];

            echo json_encode($rArray_Satisfacao);
        }

    /* FIM DA SATISFAÇÃO GERAL */ 
});

//Requisição de comparação dos postos
$app->get('/requisitar-recomendaria/:DataInicio/:DataFim/:Postos', function($DataInicio, $DataFim, $Postos) use($twig, $db) {
    $rRecomenda = $db->query("SELECT recomenda, posto_id_posto, count(*) as total FROM enquete WHERE data BETWEEN ('$DataInicio') AND ('$DataFim') AND satisfacao in (1, 2, 3, 4, 5) AND posto_id_posto in ($Postos) group by recomenda, posto_id_posto");
    
    /* RECOMENDARIA */

        $Sim = 0;
        $Nao = 0;
        $count = 0;
        foreach ($rRecomenda as $Recomenda) {
            if ($Recomenda['recomenda'] == 0) {
                $Nao += $Recomenda['total'];
                $count++;
            } 
            if ($Recomenda['recomenda'] == 1) {
                $Sim += $Recomenda['total'];
                $count++;
            }
        }

        if ($count == 0) {
            echo json_encode(['Erro' => 'Relatório sem dados suficientes.']);
        } else {
            $rArray_Recomenda = [
                'labels' => [
                    "Recomendaria", 
                    "Não recomendaria"
                ],
                'datasets' => [[
                    'label' => ['Total'],
                    'data' => [
                        $Sim,
                        $Nao
                    ],
                    'backgroundColor' => [
                        randomColor(),
                        randomColor()
                    ]
                ]]
            ];

            echo json_encode($rArray_Recomenda);
        }

    /* FIM DA RECOMENDAÇÃO */ 
});

//Requisição de comparação por periodo
$app->get('/requisitar-media-periodo/:DataInicio/:DataFim/:Postos', function($DataInicio, $DataFim, $Postos) use($twig, $db) {
    
    /* PESQUISA POR PERIODO */

        $currentDate = strtotime($DataFim);
        $Meses = [];
        while ($currentDate >= strtotime($DataInicio)) {
            $Meses[] = date('m',$currentDate);
            $currentDate = strtotime( date('Y/m/01/',$currentDate).' -1 month');
        }

        $Meses = implode(',', $Meses);

        $rRecomenda = $db->query("
            SELECT AVG(NULLIF(estacionamento, 0)) as mEstacionamento, 
            AVG(NULLIF(acesso_localizacao, 0)) as mAcesso, 
            AVG(NULLIF(atendimento_telefonico, 0)) as mAtendimentoTelefonico,
            AVG(NULLIF(atendimento_recepcao, 0)) as mAtendimentoRecepcao, 
            AVG(NULLIF(atendimento_coleta, 0)) as mAtendimentoColeta, 
            AVG(NULLIF(higiene, 0)) as mHigiene,
            AVG(NULLIF(conforto, 0)) as mConforto, 
            AVG(NULLIF(entrega_resultados, 0)) as mEntrega, data
            FROM enquete WHERE data BETWEEN ('$DataInicio') AND ('$DataFim') AND posto_id_posto in ($Postos)
            group by MONTH(data)
        ");

        $rArray_Periodo = [
            'datasets' => [[
                'label' => ['Média geral'],
            ]]
        ];

        $Meses = [];
        $count = 0;
        foreach ($rRecomenda as $key => $Recomedacao) {           
            $mGeral = (
                $Recomedacao['mEstacionamento'] + 
                $Recomedacao['mAcesso'] + 
                $Recomedacao['mAtendimentoTelefonico'] + 
                $Recomedacao['mAtendimentoRecepcao'] + 
                $Recomedacao['mAtendimentoColeta'] + 
                $Recomedacao['mHigiene'] + 
                $Recomedacao['mConforto'] + 
                $Recomedacao['mEntrega']
            ) / 8;

            $rArray_Periodo['labels'][] = [
                getMes($Recomedacao['data'])
            ];

            $rArray_Periodo['datasets'][0]['data'][] = [
                round($mGeral, 2)
            ];

            $rArray_Periodo['datasets'][0]['backgroundColor'][] = [
                randomColor()
            ];            
        }

       echo json_encode($rArray_Periodo);

    /* FIM DA PESQUISA POR PERIODO */ 
});

//Requisição para exportar em XLS
$app->get('/requisitar-xls/:DataInicio/:DataFim/:Postos', function($DataInicio, $DataFim, $Postos) use($twig, $db) {
    
    $rEnquete = $db->select('*')->from('enquete')->innerJoin('posto', 'posto.id_posto = enquete.posto_id_posto')->where("data BETWEEN ('$DataInicio') AND ('$DataFim') AND posto_id_posto in ($Postos) ")->orderByASC(['posto.id_posto'])->query();

    $dataXLS = [];
    foreach ($rEnquete as $Enquete) {
        $dataXLS[] = [
            utf8_decode("Data") => retornaData($Enquete['data']),
            utf8_decode("Posto") => utf8_decode($Enquete['nome']),
            utf8_decode("Acesso e Localização") => verificaNA($Enquete['acesso_localizacao']),
            utf8_decode("Estacionamento") => verificaNA($Enquete['estacionamento']),
            utf8_decode("Atendimento Telefônico") => verificaNA($Enquete['atendimento_telefonico']),
            utf8_decode("Atendimento na Recepção") => verificaNA($Enquete['atendimento_recepcao']),
            utf8_decode("Atendimento na Coleta") => verificaNA($Enquete['atendimento_coleta']),
            utf8_decode("Higiene e Limpeza") => verificaNA($Enquete['higiene']),
            utf8_decode("Conforto das Instalações") => verificaNA($Enquete['conforto']),
            utf8_decode("Entrega de resultados") => verificaNA($Enquete['entrega_resultados']),
            utf8_decode("Nível de satisfação") => utf8_decode(getSatisfacao($Enquete['satisfacao'])),
            utf8_decode("Recomendaria") => utf8_decode(getRecomenda($Enquete['recomenda']))
        ];
    }

    $nomeArquivo = "Relacao_Notas_".date('dmY').".xls";

    header("Content-Disposition: attachment; filename=\"$nomeArquivo\"");
    header("Content-Type: application/vnd.ms-excel");
  
    $flag = false;
    foreach($dataXLS as $row) {
        if(!$flag) {
            // display column names as first row
            echo implode("\t", array_keys($row)) . "\n";
            $flag = true;
        }
        // filter data
        array_walk($row, 'filterData');
        echo implode("\t", array_values($row)) . "\n";
    }
    
    exit;
});