<?php 

/**



 * @author Luiz Lucas

 * @version 1.0

 * Arquivo com todas as rotas do site

 * 

 */

use Psr\Http\Message\ServerRequestInterface;

use Psr\Http\Message\ResponseInterface;

//Página inicial

$app->get('/', function () use($twig, $db) {

    if(isset($_SESSION['usuarioLogado']) == true) {

        $Postos = $db->select('*')->from('posto')->query();

        renderizarView($twig, ['titulo' => 'Pesquisa de satisfação', 'Postos' => $Postos, 'viewport' => true], 'home');

    } else {

        renderizarView($twig, ['titulo' => 'Login', 'viewport' => true], 'login');

    }

});

//Processa login

$app->post('/login', function () use($twig, $db, $app) {

    extract($_POST);

    $Email = addslashes ( anti_injection( $_POST['email'] ) );

    $Senha = md5 ( addslashes ( anti_injection ( $_POST['senha'] ) ) );

    $Usuario = $db->select('*')->from('usuario')->where("email = '$Email' and senha = '$Senha'")->query();

    if(!empty($Usuario) AND validarUsuario($Usuario[0]) == true) {

       $app->redirect(URL);

    } else {

       $app->redirect(URL."/?erro=login");

    }

});

//Deslogar do sistema

$app->get('/deslogar', function () use($twig, $db) {

   finalizarSessao();

});

//Seleção do posto

$app->get('/selecionar-posto', function () use($twig, $db) {

    $Postos = $db->select('*')->from('posto')->query();

    renderizarView($twig, ['titulo' => 'Pesquisa de satisfação', 'Postos' => $Postos, 'viewport' => true], 'selecionar-posto');

});

//Processa o posto para seguir para enquete

$app->post('/processa-posto', function () use($twig, $db, $app) {

    $app->redirect(URL."/enquete/".$_POST['posto']."");

});

//Página da enquete

$app->get('/enquete/:posto', function ($Posto) use($twig, $db) {

    renderizarView($twig, ['titulo' => 'Pesquisa de satisfação', 'posto_id_posto' => $Posto, 'viewport' => true], 'enquete');

});

//Pagina de agradecimento

$app->get('/obrigado/:posto', function ($Posto) use($twig, $db) {

    renderizarView($twig, ['titulo' => 'Obrigado', 'posto_id_posto' => $Posto, 'viewport' => true], 'obrigado');

});

//Enviar enquete para o banco de dados

$app->post('/enviar-enquete', function () use($twig, $db, $app) {

    extract($_POST);

    //Verifica se o usuario marcou alguma das opções dos Emocticons, caso não o sistema da uma nota automaticamente.

    // if ()

    // (!isset($satisfacao)) ? $satisfacao = 5 : $$satisfacao = $satisfacao;

    // (!isset($recomenda)) ? $recomenda = 1 : $recomenda = $recomenda;

    //Insert no banco

    //echo '<pre>';

    //var_dump($_POST ); die();

    $respostas = [

        'posto_id_posto' => $_POST['posto_id_posto'] ?? null,

        'satisfacao_clinica' => $_POST['satisfacao_clinica'] ?? null,

        'recomendacao' => $_POST['recomendacao'] ?? null,

        'espera_senha' => $_POST['espera_senha'] ?? null,

        'at_tele_agenda' => $_POST['at_tele_agenda'] ?? null,

        'atendentes_sala' => $_POST['atendentes_sala'] ?? null,

        'tempo_exames' => $_POST['tempo_exames'] ?? '',

        'at_radiologia' => $_POST['at_radiologia'] ?? null,

        'higienizacao' => $_POST['higienizacao'] ?? null,

        'sugestao_duvida' => $_POST['sugestao_duvida'] ?? null,

        'nome' => $_POST['nome'] ?? null,

        'telefone' => $_POST['telefone'] ?? null,

        'data' => date('Y-m-d')

    ];

    $Enquete = $db->insert('enquete')->cols($respostas)->query();

    // $Enquete = $db->insert('enquete')->cols([

    //     'posto_id_posto' => $posto_id_posto,

    //     'acessibilidade' => $acessibilidade,

    //     'site' => $site,

    //     'atendimento_telefonico' => $atendimento_telefonico,

    //     'atendimento_recepcao' => $atendimento_recepcao,

    //     'atendimento_coleta' => $atendimento_coleta,

    //     'higiene' => $higiene,

    //     'informacao' => $informacao,

    //     'satisfacao' => $satisfacao,

    //     'recomenda' => $recomenda,

    //     'data' => date('Y-m-d')

    // ])->query();

     // $Posto = $db->select('nome')->from('posto')->where("id_posto = $posto_id_posto")->query();

    //Enviar para o email

    $Mensagem = "Nova pesquisa preenchida!";

    // $Mensagem = "

    //  Nova pesquisa preenchida! <br/> <br/>

    //  <b>Meio</b>: ${$respostas['meio']} <br/>

    //  <b>Meio</b>: ${$respostas['motivo']} <br/>

    //  <b>Meio</b>: ${$respostas['atendimento_tele']} <br/>

    //  <b>Meio</b>: ${$respostas['simpatia_recepcao']} <br/>

    //  <b>Meio</b>: ${$respostas['tempo_recepcao']} <br/>

    //  <b>Meio</b>: ${$respostas['recep']} <br/>

    //  <b>Meio</b>: ${$respostas['simpatia_exames']} <br/>

    //  <b>Meio</b>: ${$respostas['tempo_exames']} <br/>

    //  <b>Meio</b>: ${$respostas['profissional']} <br/>

    // ";

 //    $Mensagem = "

 //        Nova pesquisa preenchida! <br/> <br/>

 //        <b>Data</b>: ".date('d/m/Y')." <br/>

 //        <b>Posto</b>: ".utf8_decode($Posto[0]['nome'])." <br/> <br/>

 //        <b>Clareza nas informações</b>: ".$informacao." <br/>

 //        <b>Atendimento da recepção</b>: ".$atendimento_recepcao." <br/>

 //        <b>Atendimento da coleta</b>: ".$atendimento_coleta." <br/>

 //        <b>Central telefônica</b>: ".$atendimento_telefonico." <br/>

 //        <b>Limpeza das instalações</b>: ".$higiene." <br/>

 //        <b>Acessibilidade</b>: ".$acessibilidade." <br/>

 //        <b>Site</b>: ".$site." <br/> <br/>

 //        <b>Satisfação geral</b>: ".$satisfacao." <br/>

 //        <b>Recomendaria</b>: ".$recomenda." <br/>

 //        <b>Porque</b>: <br/>".$porque."

 //    ";

    // $Mensagem = "

    //     Nova pesquisa preenchida! <br/>

    //     Data: ".date('d/m/Y')." <br/>

    //     <b>Posto</b>: ".utf8_decode($Posto[0]['nome'])." <br/> <br/>

    //     Clareza nas informações: ".$clareza_info." <br/>

    //     Atendimento da recepção: ".$atend_recepcao." <br/>

    //     Atendimento da coleta: ".$atend_coleta." <br/>

    //     Central telefônica: ".$central_tel." <br/>

    //     Limpeza das instalações: ".$limpeza." <br/>

    //     Acessibilidade: ".$acessibilidade." <br/>

    //     Site: ".$site." <br/> <br/>

    //     Satisfação geral: ".getSatisfacao($nota_serv_lab)." <br/>

    //     Recomendaria: ".getRecomenda($recomenda)."

    // ";

    enviarEmail("Robô da Enquete", EMAIL_ADMIN, "Nova pesquisa preenchida", $Mensagem);

    $app->redirect(URL."/obrigado/$posto_id_posto");

});

//Página de filtros

$app->get('/gerar-relatorio', function() use($twig, $db) {

    $todosPostos = $db->select('*')->from('posto')->query();

    $InicioMes = date('d/m/Y', mktime(0, 0, 0, date('m') , 1 , date('Y')));

    $FimMes = date('d/m/Y', mktime(23, 59, 59, date('m'), date("t"), date('Y')));

    renderizarView($twig, ['titulo' => 'Gerar relatório', 'Postos' => $todosPostos, 'DataPadrao' => [$InicioMes, $FimMes], 'viewport' => true], 'filtros');

});

//Página dos relatórios

$app->post('/relatorios', function() use($twig, $db) {

    extract($_POST);

    $Datas = explode(' - ', $periodo);

    $Data_Inicio = gravaData($Datas[0]); $Data_Fim = gravaData($Datas[1]);

    if (!isset($postos)) {

        $postos = $db->select('id_posto')->from('posto')->query();

        $listaPostos = [];

        foreach ($postos as $posto) {

            $listaPostos[] = $posto['id_posto'];

        }

        $postos = implode(',', $listaPostos);

    } else {

        $postos = implode(',', array_map('intval', $postos));

    }

    renderizarView($twig, ['titulo' => 'Relatórios e gráficos', 'Filtros' => ['DataInicio' => $Data_Inicio, 'DataFim' => $Data_Fim , 'Postos' => $postos], 'viewport' => true], 'relatorios');

});

/* Requisições para os relatórios */

//Requisição de Avaliação dos serviços

$app->get('/requisitar-avaliacao-servicos/:DataInicio/:DataFim/:Postos', function($DataInicio, $DataFim, $Postos) use($twig, $db) {

    try{

            /* AVALIAÇÃO DE SERVIÇOS */

        $query_avaliacao_servicos = $db->query(

        "

             SELECT

               round(avg(satisfacao_clinica), 1) as satisfacao_clinica,

               round(avg(recomendacao),1) as recomendacao,

               round(avg(espera_senha),1) as espera_senha,             

               round(avg(at_tele_agenda),1) as at_tele_agenda,                

               round(avg(atendentes_sala),1) as atendentes_sala,                

               round(avg(tempo_exames),1) as tempo_exames,         

               round(avg(at_radiologia),1) as at_radiologia,  

               round(avg(higienizacao),1) as higienizacao,

               COUNT(recomendacao) as quantidade

             FROM enquete

             WHERE 

                data BETWEEN ('$DataInicio') AND ('$DataFim')

                AND posto_id_posto in ($Postos);      

        ");

        

        $query_medical = $db->query(

        "

             SELECT COUNT(enquete.id_enquente) as quantidade, posto.nome as nome

             FROM enquete INNER JOIN posto on posto.id_posto = enquete.posto_id_posto

             WHERE 

                data BETWEEN ('$DataInicio') AND ('$DataFim') AND posto_id_posto in ($Postos)

                GROUP BY enquete.posto_id_posto; 

        ");

        

        

        $avaliacao_servicos = $query_avaliacao_servicos[0];

        

        for($i=0; $i<count($query_medical); $i++){

           if($query_medical[$i]['nome'] === 'Unidade Medical Gênesis'){

               $query1 = $query_medical[$i];

           }

           if($query_medical[$i]['nome'] === 'Unidade Hospital Gênesis'){

               $query2 = $query_medical[$i];

           }

           if($query_medical[$i]['nome'] === 'Unidade BS Tower'){

               $query3 = $query_medical[$i];

           }

         }

         

         $query1 = (!isset($query1))?['quantidade'=>0, 'nome'=>'--']:$query1;

         $query2 = (!isset($query2))?['quantidade'=>0, 'nome'=>'--']:$query2;

         $query3 = (!isset($query3))?['quantidade'=>0, 'nome'=>'--']:$query3;

        

        $grafico_avaliacao_dados = [

            'labels' => [

                "Satisfação - Clínica", 

                "Recomenda", 

                "Espera senha", 

                "At. tel. e agendamento", 

                "Atendentes na sala",  

                "Tempo - Exames", 

                "At. téc. radiologia",

                "Higienização"

            ],

            'datasets' => [[

                'label' => ['# Média'],

                'data' => [

                   $avaliacao_servicos['satisfacao_clinica'],

                   $avaliacao_servicos['recomendacao'],

                   $avaliacao_servicos['espera_senha'],             

                   $avaliacao_servicos['at_tele_agenda'],                

                   $avaliacao_servicos['atendentes_sala'],                

                   $avaliacao_servicos['tempo_exames'],         

                   $avaliacao_servicos['at_radiologia'],

                   $avaliacao_servicos['higienizacao'],

                   1

                ],

                'data_quantidade' => [

                    $avaliacao_servicos['quantidade']

                    ],

                'quant_med' => [

                    $query1['quantidade']

                    ],

                'quant_hp' => [

                    $query2['quantidade']

                    ],

                'quant_bs' => [

                    $query3['quantidade']

                    ],

                'backgroundColor' => [

                    randomColor(),

                    randomColor(),

                    randomColor(),

                    randomColor(),

                    randomColor(),

                    randomColor(),

                    randomColor()

                ]

            ]]

        ];

        echo json_encode($grafico_avaliacao_dados);

    } catch (Exception $e) {

        var_dump($e);

        var_dump($e->getMessage());

        die();

        echo json_encode(['Erro' => 'Relatório sem dados suficientes.']);

    }

    /* FIM DA AVALIAÇÃO DE SERVIÇOS */ 

});

            // SELECT 

            //     count(meio) as contador_respostas,

            //     respostas.descricao as descricao 

            // FROM enquete, respostas 

            // WHERE respostas.id = enquete.meio GROUP BY meio;

        //             $labels = array_map(function (row) {

        //     return row['descricao'];

        // }, $avaliacao_servicos);

//Requisição de Avaliação da satisfação

$app->get('/requisitar-satisfacao-geral/:DataInicio/:DataFim/:Postos', function($DataInicio, $DataFim, $Postos) use($twig, $db) {

   try{

            /* AVALIAÇÃO DE SERVIÇOS */

        $query_avaliacao_servicos = $db->query(

        "

            SELECT 

                count(meio) as contador_respostas,

                respostas.descricao as descricao 

            FROM enquete, respostas 

            WHERE respostas.id = enquete.meio GROUP BY meio;

        ");

        $labels = array_map(function($row) {

            return $row['descricao'];

        }, $query_avaliacao_servicos);

        $data = array_map(function($row) {

            return $row['contador_respostas'];

        }, $query_avaliacao_servicos);

        $colors = array_map(function($row) {

            return randomColor();

        }, $query_avaliacao_servicos);

        $grafico_avaliacao_dados = [

            'labels' => $labels,

            'datasets' => [[

                'label' => ['# Média'],

                'data' => $data,

                'backgroundColor' => $colors

            ]]

        ];

        echo json_encode($grafico_avaliacao_dados);

    } catch (Exception $e) {

        var_dump($e);

        var_dump($e->getMessage());

        die();

        echo json_encode(['Erro' => 'Relatório sem dados suficientes.']);

    }

});

//Requisição de comparação dos postos

$app->get('/requisitar-recomendaria/:DataInicio/:DataFim/:Postos', function($DataInicio, $DataFim, $Postos) use($twig, $db) {

        try{

            /* AVALIAÇÃO DE SERVIÇOS */

        $query_avaliacao_servicos = $db->query(

        "

            SELECT 

                count(motivo) as contador_respostas,

                respostas.descricao as descricao 

            FROM enquete, respostas 

            WHERE respostas.id = enquete.motivo GROUP BY motivo;

        ");

        $labels = array_map(function($row) {

            return $row['descricao'];

        }, $query_avaliacao_servicos);

        $data = array_map(function($row) {

            return $row['contador_respostas'];

        }, $query_avaliacao_servicos);

        $colors = array_map(function($row) {

            return randomColor();

        }, $query_avaliacao_servicos);

        $grafico_avaliacao_dados = [

            'labels' => $labels,

            'datasets' => [[

                'label' => ['# Média'],

                'data' => $data,

                'backgroundColor' => $colors

            ]]

        ];

        echo json_encode($grafico_avaliacao_dados);

    } catch (Exception $e) {

        var_dump($e);

        var_dump($e->getMessage());

        die();

        echo json_encode(['Erro' => 'Relatório sem dados suficientes.']);

    }

});

//Requisição de comparação por periodo

$app->get('/requisitar-media-periodo/:DataInicio/:DataFim/:Postos', function($DataInicio, $DataFim, $Postos) use($twig, $db) {

    /* PESQUISA POR PERIODO */

        $currentDate = strtotime($DataFim);

        $Meses = [];

        while ($currentDate >= strtotime($DataInicio)) {

            $Meses[] = date('m',$currentDate);

            $currentDate = strtotime( date('Y/m/01/',$currentDate).' -1 month');

        }

        $Meses = implode(',', $Meses);

        $rRecomenda = $db->query("

            SELECT AVG(NULLIF(site, 0)) as mSite, 

            AVG(NULLIF(acesso_localizacao, 0)) as mAcesso, 

            AVG(NULLIF(atendimento_telefonico, 0)) as mAtendimentoTelefonico,

            AVG(NULLIF(atendimento_recepcao, 0)) as mAtendimentoRecepcao, 

            AVG(NULLIF(atendimento_coleta, 0)) as mAtendimentoColeta, 

            AVG(NULLIF(higiene, 0)) as mHigiene,

            AVG(NULLIF(informacao, 0)) as mInformacao, data

            FROM enquete WHERE data BETWEEN ('$DataInicio') AND ('$DataFim') AND posto_id_posto in ($Postos)

            group by MONTH(data)

        ");

        $rArray_Periodo = [

            'datasets' => [[

                'label' => ['Média geral'],

            ]]

        ];

        $Meses = [];

        $count = 0;

        foreach ($rRecomenda as $key => $Recomedacao) {

            $mGeral = (

                $Recomedacao['mSite'] + 

                $Recomedacao['mAcesso'] + 

                $Recomedacao['mAtendimentoTelefonico'] + 

                $Recomedacao['mAtendimentoRecepcao'] + 

                $Recomedacao['mAtendimentoColeta'] + 

                $Recomedacao['mHigiene'] + 

                $Recomedacao['mInformacao'] 

            ) / 7;

            $rArray_Periodo['labels'][] = [

                getMes($Recomedacao['data'])

            ];

            $rArray_Periodo['datasets'][0]['data'][] = [

                round($mGeral, 2)

            ];

            $rArray_Periodo['datasets'][0]['backgroundColor'][] = [

                randomColor()

            ];            

        }

       echo json_encode($rArray_Periodo);

    /* FIM DA PESQUISA POR PERIODO */ 

});

//Requisição para exportar em XLS

$app->get('/requisitar-xls/:DataInicio/:DataFim/:Postos', function($DataInicio, $DataFim, $Postos) use($twig, $db) {

/*    $rEnquete = $db

        ->select('*')

        ->from('enquete')

        ->innerJoin('posto', 'posto.id_posto = enquete.posto_id_posto')

        ->where("data BETWEEN ('$DataInicio') AND ('$DataFim') AND posto_id_posto in ($Postos) ")

        ->orderByASC(['posto.id_posto'])

        ->query();

*/

    $rEnquete = $db

        ->select('

            (SELECT descricao from respostas where id = enquete.satisfacao_clinica) as satisfacao_clinica,

            (SELECT descricao from respostas where id = enquete.recomendacao) as recomendacao,

            (SELECT descricao from respostas where id = enquete.espera_senha) as espera_senha,

            (SELECT descricao from respostas where id = enquete.at_tele_agenda) as at_tele_agenda,

            (SELECT descricao from respostas where id = enquete.atendentes_sala) as atendentes_sala,

            (SELECT descricao from respostas where id = enquete.tempo_exames) as tempo_exames,

            (SELECT descricao from respostas where id = enquete.at_radiologia) as at_radiologia,

            (SELECT descricao from respostas where id = enquete.higienizacao) as higienizacao,

            enquete.sugestao_duvida as sugestao_duvida,

            enquete.nome as nome,

            enquete.telefone as telefone,

            enquete.data as data,

            posto.nome as nome_posto

        ')

        ->from('enquete')

        ->innerJoin('posto', 'posto.id_posto = enquete.posto_id_posto')

        ->where("data BETWEEN ('$DataInicio') AND ('$DataFim') AND posto_id_posto in ($Postos) ")

        ->orderByASC(['posto.id_posto'])

        ->query();

        

    

     $row_cnt = count($rEnquete);

    

    $dataXLS = [];

    foreach ($rEnquete as $Enquete) {

        $dataXLS[] = [

            'satisfacao_clinica' => $Enquete['satisfacao_clinica'],

            'recomendacao' => $Enquete['recomendacao'],

            'espera_senha' => $Enquete['espera_senha'],

            'at_tele_agenda' => $Enquete['at_tele_agenda'],

            'atendentes_sala' => $Enquete['atendentes_sala'],

            'tempo_exames' => $Enquete['tempo_exames'],

            'at_radiologia' => $Enquete['at_radiologia'],

            'higienizacao' => $Enquete['higienizacao'],

            'sugestao_duvida' => str_replace(",", '.', $Enquete['sugestao_duvida']),

            'nome' => $Enquete['nome'],

            'telefone' => $Enquete['telefone'],

            'data' => retornaData($Enquete['data']),

            'nome_posto' => $Enquete['nome_posto'],

        ];

    }

    $dataXLS[] = [

            'Quantidade' => "Total de respostas: " . $row_cnt

            ];

    $nomeArquivo = "Relacao_Notas_" . date('dmY') . ".xls";

    header("Content-Disposition: attachment; filename=\"$nomeArquivo\"");

    header("Content-Type: application/vnd.ms-excel");

    $flag = false;

    foreach($dataXLS as $row) {

        if(!$flag) {

            // display column names as first row

            echo implode("\t", array_keys($row)) . "\n";

            $flag = true;

        }

        // filter data

        array_walk($row, 'filterData');

        echo implode("\t", array_values($row)) . "\n";

    }

    exit;

});