<?php
/**
 * @author Luiz Lucas
 * @version 1.0
 * Arquivo com todas as rotas do site
 *
 */

use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Message\ResponseInterface;

//Página inicial
$app->get('/', function () use ($twig, $db) {
    if (isset($_SESSION['usuarioLogado']) == true) {
        $Postos = $db->select('*')->from('posto')->query();
        renderizarView($twig, ['titulo' => 'Pesquisa de satisfação', 'Postos' => $Postos, 'viewport' => true], 'home');
    } else {
        renderizarView($twig, ['titulo' => 'Login', 'viewport' => true], 'login');
    }
});

//Processa login
$app->post('/login', function () use ($twig, $db, $app) {
    extract($_POST);


    $Email = addslashes(anti_injection($_POST['email']));
    $Senha = md5(addslashes(anti_injection($_POST['senha'])));

    $Usuario = $db->select('*')->from('usuario')->where("email = '$Email' and senha = '$Senha'")->query();

    if (!empty($Usuario) AND validarUsuario($Usuario[0]) == true) {
        $app->redirect(URL);
    } else {
        $app->redirect(URL . "/?erro=login");
    }
});

//Deslogar do sistema
$app->get('/deslogar', function () use ($twig, $db) {
    finalizarSessao();
});

//Seleção do posto
$app->get('/selecionar-posto', function () use ($twig, $db) {
    $Postos = $db->select('*')->from('posto')->query();

    renderizarView($twig, ['titulo' => 'Pesquisa de satisfação', 'Postos' => $Postos, 'viewport' => true], 'selecionar-posto');
});

//Processa o posto para seguir para enquete
$app->post('/processa-posto', function () use ($twig, $db, $app) {
    $app->redirect(URL . "/enquete/" . $_POST['posto'] . "");
});

//Página da enquete
$app->get('/enquete/:posto', function ($Posto) use ($twig, $db) {
    renderizarView($twig, ['titulo' => 'Pesquisa de satisfação', 'posto_id_posto' => $Posto, 'viewport' => true], 'enquete');
});

//Pagina de agradecimento
$app->get('/obrigado/:posto', function ($Posto) use ($twig, $db) {
    renderizarView($twig, ['titulo' => 'Obrigado', 'posto_id_posto' => $Posto, 'viewport' => true], 'obrigado');
});


//Enviar enquete para o banco de dados
$app->post('/enviar-enquete', function () use ($twig, $db, $app) {
    extract($_POST);

//    echo '<pre>';
//    var_dump($_POST);
    //Define o POSTO
    $posto_id_posto = $_POST['posto_id_posto'];

    //Sugestão
    $sugestao = $_POST['sugestao'];

    //Verifica se o usuario marcou alguma das opções dos Emocticons, caso não o sistema da uma nota automaticamente.
    $satisfacao = 5;
    if (isset($_POST['satisfacaoUnidade'])) {
        $satisfacao = $_POST['satisfacaoUnidade'];
    }

    //Enviar para o email
    $recomendaEmail = 'NÃO';
    $recomenda = 0;
    if (isset($_POST['recomendaUnidade'])) {
        $recomenda = $_POST['recomendaUnidade'];

        if ($recomenda == 1)
            $recomendaEmail = 'SIM';
    }

    //Array do banco
    $array = array(
        'posto_id_posto' => $posto_id_posto,
        'satisfacao' => $satisfacao,
        'recomenda' => $recomenda,
        'sugestao' => $sugestao,
        'data' => Date('Y-m-d H:i:s u')
    );

//    var_dump($array);
//    die();
    //Insert no banco
    $db->insert('enquete')->cols($array)->query();

    $Posto = $db->select('nome')->from('posto')->where("id_posto = $posto_id_posto")->query();

    $Mensagem = "
        Nova pesquisa preenchida! <br/> <br/>
        <b>Data</b>: " . date('d/m/Y') . " <br/>
        <b>Posto</b>: " . utf8_decode($Posto[0]['nome']) . " <br/> <br/>
        <b>Sugestão</b>: " . $sugestao . " <br/> <br/>
        <b>Satisfação geral</b>: " . $satisfacao . " <br/>
        <b>Recomenda: </b>: " . $recomendaEmail . "<br/>";

    enviarEmail("Robô da Enquete", EMAIL_ADMIN, "Nova pesquisa preenchida", $Mensagem);

    $app->redirect(URL . "/obrigado/$posto_id_posto");
});

//Página de filtros
$app->get('/gerar-relatorio', function () use ($twig, $db) {
    $todosPostos = $db->select('*')->from('posto')->query();
    $InicioMes = date('d/m/Y');
    $FimMes = date('d/m/Y');

    renderizarView($twig, ['titulo' => 'Gerar relatório', 'Postos' => $todosPostos, 'DataPadrao' => [$InicioMes, $FimMes], 'viewport' => true], 'filtros');
});

//Página dos relatórios
$app->post('/relatorios', function () use ($twig, $db) {
    extract($_POST);


    $Datas1 = implode('-', array_reverse(explode('/', $_POST['datetimepicker6'])));
    $Datas2 = implode('-', array_reverse(explode('/', $_POST['datetimepicker5'])));

    if (trim($Datas1) == '')
        $Datas1 = date('Y-m-d');

    if (trim($Datas2) == '')
        $Datas2 = $Datas1;

    $Data_Inicio = $Datas1 . ' 00:00:00';
    $Data_Fim = $Datas2 . ' 23:59:59';

     
    if (!isset($postos)) {
        $postos = $db->select('id_posto')->from('posto')->query();

        $listaPostos = [];
        foreach ($postos as $posto) {
            $listaPostos[] = $posto['id_posto'];
        }

        $postos = implode(',', $listaPostos);
    } else {
        $postos = implode(',', array_map('intval', $postos));
    }

    renderizarView($twig, ['titulo' => 'Relatórios e gráficos', 'Filtros' => ['DataInicio' => $Data_Inicio, 'DataFim' => $Data_Fim, 'Postos' => $postos], 'viewport' => true], 'relatorios');
});

/* Requisições para os relatórios */

//Requisição de relatorios de DETRATORES
$app->get('/requisitar-detratores-geral/:DataInicio/:DataFim/:Postos', function ($DataInicio, $DataFim, $Postos) use ($twig, $db) {
    $rPostos = $db->query("SELECT satisfacao, count(*) as total FROM enquete WHERE data BETWEEN ('$DataInicio') AND ('$DataFim') AND satisfacao in (1, 2, 3, 4, 5, 6) AND posto_id_posto in ($Postos)");

    $detretor = 0;
    $count = 0;
    foreach ($rPostos as $Satisfacao) {
        if ($Satisfacao['satisfacao'] < 7) {
            $detretor = $Satisfacao['total'];
            $count++;
        }

    }

    /* relatorio chart.js */
    if ($count <= 0) {
        echo json_encode(['Erro' => 'Relatório sem dados suficientes.']);
    } else {
        $Detretores = [
            'labels' => [
                "Total de detratores",
            ],
            'datasets' => [[
                'data' => [
                    $detretor,
                ],
                'backgroundColor' => [
                    'rgba(207, 0, 15, 1)'
                ]
            ]]
        ];

        echo json_encode($Detretores);
    }
});

//Requisição de relatorios de NEUTROS
$app->get('/requisitar-neutros-geral/:DataInicio/:DataFim/:Postos', function ($DataInicio, $DataFim, $Postos) use ($twig, $db) {
    $rPostos = $db->query("SELECT satisfacao, count(*) as total FROM enquete WHERE data BETWEEN ('$DataInicio') AND ('$DataFim') AND satisfacao in (7, 8) AND posto_id_posto in ($Postos)");

    $neutro = 0;
    $count = 0;
    foreach ($rPostos as $Satisfacao) {
        if ($Satisfacao['satisfacao'] > 6 && $Satisfacao['satisfacao'] < 9) {
            $neutro = $Satisfacao['total'];
            $count++;
        }

    }

    /* relatorio chart.js */
    if ($count <= 0) {
        echo json_encode(['Erro' => 'Relatório sem dados suficientes.']);
    } else {
        $Neutros = [
            'labels' => [
                "Total de Neutros",
            ],
            'datasets' => [[
                'data' => [
                    $neutro,
                ],
                'backgroundColor' => [
                    'rgba(255,193,7,1)'
                ]
            ]]
        ];

        echo json_encode($Neutros);
    }
});

//Requisição de relatorios de Promotores
$app->get('/requisitar-promotores-geral/:DataInicio/:DataFim/:Postos', function ($DataInicio, $DataFim, $Postos) use ($twig, $db) {
    $rPostos = $db->query("SELECT satisfacao, count(*) as total FROM enquete WHERE data BETWEEN ('$DataInicio') AND ('$DataFim') AND satisfacao in (9, 10) AND posto_id_posto in ($Postos)");

    $promotores = 0;
    $count = 0;
    foreach ($rPostos as $Satisfacao) {
        if ($Satisfacao['satisfacao'] > 8) {
            $promotores = $Satisfacao['total'];
            $count++;
        }

    }

    /* relatorio chart.js */
    if ($count <= 0) {
        echo json_encode(['Erro' => 'Relatório sem dados suficientes.']);
    } else {
        $Promotores = [
            'labels' => [
                "Total de Promotores",
            ],
            'datasets' => [[
                'data' => [
                    $promotores,
                ],
                'backgroundColor' => [
                    'rgba(40,167,69,1)'
                ]
            ]]
        ];

        echo json_encode($Promotores);
    }
});

//Requisição de Avaliação da satisfação
$app->get('/requisitar-satisfacao-geral/:DataInicio/:DataFim/:Postos', function ($DataInicio, $DataFim, $Postos) use ($twig, $db) {
    $rSatisfacao = $db->query("SELECT satisfacao, posto_id_posto, count(*) as total FROM enquete WHERE data BETWEEN ('$DataInicio') AND ('$DataFim') AND satisfacao in (1, 2, 3, 4, 5, 6,7,8, 9, 10) AND posto_id_posto in ($Postos) group by satisfacao");

    /* SATISFAÇÃO GERAL */

    $detrator = 0;
    $neutro = 0;
    $promotor = 0;
    $count = 0;

    $detrator_porcentagem = 0;
    $neutro_porcentagem = 0;
    $promotor_porcentagem = 0;

    foreach ($rSatisfacao as $Satisfacao) {

        if ($Satisfacao['satisfacao'] <= 6) {
            $detrator += $Satisfacao['total'];
            $count++;
        }
        if ($Satisfacao['satisfacao'] >= 7 and $Satisfacao['satisfacao'] <= 8) {
            $neutro += $Satisfacao['total'];
            $count++;
        }
        if ($Satisfacao['satisfacao'] > 8) {
            $promotor += $Satisfacao['total'];
            $count++;
        }
    }

    $count = $detrator + $neutro + $promotor;

    $detrator_porcentagem = ceil(($detrator / $count) * 100);
    $neutro_porcentagem = floor(($neutro / $count) * 100);
    $promotor_porcentagem = floor(($promotor / $count) * 100);

    if ($count <= 1) {
        echo json_encode(['Erro' => 'Relatório sem dados suficientes.']);
    } else {

        $rArray_Satisfacao = [
            'labels' => [
                "Detrator total = " . $detrator,
                "Neutro total = " . $neutro,
                "Promotor total = " . $promotor,
            ],
            'datasets' => [[
                'data' => [
                    $detrator_porcentagem,
                    $neutro_porcentagem,
                    $promotor_porcentagem
                ],
                'backgroundColor' => [
                    'rgba(207, 0, 15, 1)',
                    'rgba(255,193,7,1)',
                    'rgba(40,167,69,1)'
                ]
            ]]
        ];

        echo json_encode($rArray_Satisfacao);
    }

    /* FIM DA SATISFAÇÃO GERAL */
});

//Requisição de comparação dos postos

$app->get('/requisitar-recomendaria/:DataInicio/:DataFim/:Postos', function ($DataInicio, $DataFim, $Postos) use ($twig, $db) {
    $rRecomenda = $db->query("SELECT recomenda, posto_id_posto, count(*) as total FROM enquete WHERE data BETWEEN ('$DataInicio') AND ('$DataFim') AND satisfacao in (1,2,3,4,5,6,7,8,9,10) AND posto_id_posto in ($Postos) group by recomenda, posto_id_posto");

    /* RECOMENDARIA */

    $Sim = 0;
    $Nao = 0;
    $count = 0;
    foreach ($rRecomenda as $Recomenda) {
        if ($Recomenda['recomenda'] == 0) {
            $Nao += $Recomenda['total'];
            $count++;
        }
        if ($Recomenda['recomenda'] == 1) {
            $Sim += $Recomenda['total'];
            $count++;
        }
    }
    if ($count == 0) {
        echo json_encode(['Erro' => 'Relatório sem dados suficientes.']);
    } else {
        $rArray_Recomenda = [
            'labels' => [
                "Recomendaria",
                "Não recomendaria"
            ],
            'datasets' => [[
                'label' => ['Total'],
                'data' => [
                    $Sim,
                    $Nao
                ],
                'backgroundColor' => [
                    'rgba(0,123,255,1)',
                    'rgba(207, 0, 15, 1)'
                ]
            ]]
        ];

        echo json_encode($rArray_Recomenda);
    }
    /* FIM DA RECOMENDAÇÃO */
});

//Requisição de comparação por periodo

$app->get('/requisitar-media-periodo/:DataInicio/:DataFim/:Postos', function ($DataInicio, $DataFim, $Postos) use ($twig, $db) {

    /* PESQUISA POR PERIODO */

    $currentDate = strtotime($DataFim);
    $Meses = [];
    while ($currentDate >= strtotime($DataInicio)) {
        $Meses[] = date('m', $currentDate);
        $currentDate = strtotime(date('Y/m/01/', $currentDate) . ' -1 month');
    }

    $Meses = implode(',', $Meses);

    $rRecomenda = $db->query("
            SELECT AVG(NULLIF(satisfacao, 0)) as mSatisfacao,data 
            FROM enquete WHERE data BETWEEN ('$DataInicio') AND ('$DataFim') AND posto_id_posto in ($Postos)
            group by MONTH(data)");

    $rArray_Periodo = [
        'datasets' => [[
            'label' => ['Média geral'],
        ]]
    ];

    $Meses = [];
    $count = 0;
    foreach ($rRecomenda as $key => $Recomedacao) {

        $mGeral = (
            $Recomedacao['mSatisfacao']
            ) / 5;

        $rArray_Periodo['labels'][] = [
            getMes($Recomedacao['data'])
        ];

        $rArray_Periodo['datasets'][0]['data'][] = [
            round($mGeral, 2)
        ];

        $rArray_Periodo['datasets'][0]['backgroundColor'][] = [
            randomColor()
        ];
    }

    echo json_encode($rArray_Periodo);

    /* FIM DA PESQUISA POR PERIODO */
});

//Requisição para exportar em XLS
$app->get('/requisitar-xls/:DataInicio/:DataFim/:Postos', function ($DataInicio, $DataFim, $Postos) use ($twig, $db) {

    $rEnquete = $db->select('*')->from('enquete')->innerJoin('posto', 'posto.id_posto = enquete.posto_id_posto')->where("data BETWEEN ('$DataInicio') AND ('$DataFim') AND posto_id_posto in ($Postos) ")->orderByASC(['posto.id_posto'])->query();

    $dataXLS = [];
    foreach ($rEnquete as $Enquete) {
        $dataXLS[] = [
            utf8_decode("Data") => retornaData($Enquete['data']),
            utf8_decode("Hora") => retornaHora($Enquete['data']),
            utf8_decode("Posto") => utf8_decode($Enquete['nome']),
            utf8_decode("Nivel de satisfacao") => utf8_decode($Enquete['satisfacao']),
            utf8_decode("Classificao") => retornarClassificacao($Enquete['satisfacao']),
            utf8_decode("Recomenda") => (utf8_decode($Enquete['recomenda'] == 1) ? "Recomenda" : "Não Recomenda"),
            utf8_decode("Sugestao") => utf8_decode($Enquete['sugestao'])
        ];
    }

    $nomeArquivo = "Relacao_Notas_" . date('dmY') . ".xls";

    header("Content-Disposition: attachment; filename=\"$nomeArquivo\"");
    header("Content-Type: application/vnd.ms-excel");

    $flag = false;
    foreach ($dataXLS as $row) {
        if (!$flag) {
            // display column names as first row
            echo implode("\t", array_keys($row)) . "\n";
            $flag = true;
        }
        // filter data
        array_walk($row, 'filterData');
        echo implode("\t", array_values($row)) . "\n";

    }

    exit;
});

//Requisição de Avaliação da satisfação
$app->get('/requisitar-nps/:DataInicio/:DataFim/:Postos', function ($DataInicio, $DataFim, $Postos) use ($twig, $db) {
    $rSatisfacao = $db->query("SELECT satisfacao, posto_id_posto, count(*) as total FROM enquete WHERE data BETWEEN ('$DataInicio') AND ('$DataFim') AND satisfacao in (1, 2, 3, 4, 5, 6,7,8, 9, 10) AND posto_id_posto in ($Postos) group by satisfacao");

    /* SATISFAÇÃO GERAL */

    $detrator = 0;
    $neutro = 0;
    $promotor = 0;
    $count = 0;
    $nps = 0;

    $detrator_porcentagem = 0;
    $promotor_porcentagem = 0;

    foreach ($rSatisfacao as $Satisfacao) {

        if ($Satisfacao['satisfacao'] <= 6) {
            $detrator += $Satisfacao['total'];
            $count++;
        }
        if ($Satisfacao['satisfacao'] >= 7 and $Satisfacao['satisfacao'] <= 8) {
            $neutro += $Satisfacao['total'];
            $count++;
        }
        if ($Satisfacao['satisfacao'] > 8) {
            $promotor += $Satisfacao['total'];
            $count++;
        }
    }

    $count = $detrator + $neutro + $promotor;

    $detrator_porcentagem = ceil(($detrator / $count) * 100);
    $promotor_porcentagem = floor(($promotor / $count) * 100);

    $nps = $promotor_porcentagem - $detrator_porcentagem;

    echo json_encode($nps);

    /* FIM DA SATISFAÇÃO GERAL */
});