<?php 



/**

 * @author Luiz Lucas

 * @version 1.0

 * Arquivo com todas as rotas do site

 * 

 */



use Psr\Http\Message\ServerRequestInterface;

use Psr\Http\Message\ResponseInterface;



//Página inicial

$app->get('/', function () use($twig, $db) {

    if(isset($_SESSION['usuarioLogado']) == true) {

        $Postos = $db->select('*')->from('posto')->query();

        renderizarView($twig, ['titulo' => 'Pesquisa de satisfação', 'Postos' => $Postos, 'viewport' => true], 'home');

    } else {

        renderizarView($twig, ['titulo' => 'Login', 'viewport' => true], 'login');

    }

});



//Processa login

$app->post('/login', function () use($twig, $db, $app) {

    extract($_POST);



    $Email = addslashes ( anti_injection( $_POST['email'] ) );

    $Senha = md5 ( addslashes ( anti_injection ( $_POST['senha'] ) ) );



    $Usuario = $db->select('*')->from('usuario')->where("email = '$Email' and senha = '$Senha'")->query();



    if(!empty($Usuario) AND validarUsuario($Usuario[0]) == true) {

       $app->redirect(URL);

    } else {

       $app->redirect(URL."/?erro=login");

    }

});



//Deslogar do sistema

$app->get('/deslogar', function () use($twig, $db) {

   finalizarSessao();

});



//Seleção do posto

$app->get('/selecionar-posto', function () use($twig, $db) {

    $Postos = $db->select('*')->from('posto')->query();

    renderizarView($twig, ['titulo' => 'Pesquisa de satisfação', 'Postos' => $Postos, 'viewport' => true], 'selecionar-posto');

});



//Processa o posto para seguir para enquete

$app->post('/processa-posto', function () use($twig, $db, $app) {

    $app->redirect(URL."/enquete/".$_POST['posto']."");

});



//Página da enquete

$app->get('/enquete/:posto', function ($Posto) use($twig, $db) {

    renderizarView($twig, ['titulo' => 'Pesquisa de satisfação', 'posto_id_posto' => $Posto, 'viewport' => true], 'enquete');

});



//Pagina de agradecimento

$app->get('/obrigado/:posto', function ($Posto) use($twig, $db) {

    renderizarView($twig, ['titulo' => 'Obrigado', 'posto_id_posto' => $Posto, 'viewport' => true], 'obrigado');

});



//Enviar enquete para o banco de dados

$app->post('/enviar-enquete', function () use($twig, $db, $app) {

    extract($_POST);



    //Verifica se o usuario marcou alguma das opções dos Emocticons, caso não o sistema da uma nota automaticamente.

    (!isset($satisfacao)) ? $satisfacao = 4 : $satisfacao = $satisfacao;

    (!isset($recomenda)) ? $recomenda = 1 : $recomenda = $recomenda;



    //Insert no banco

    $Enquete = $db->insert('enquete')->cols([

    	'posto_id_posto' => $posto_id_posto,

    	'acesso_localizacao' => $acesso_localizacao,

    	'estacionamento' => $estacionamento,

    	'atendimento_telefonico' => $atendimento_telefonico,

    	'atendimento_recepcao' => $atendimento_recepcao,

    	'atendimento_coleta' => $atendimento_coleta,

    	'higiene' => $higiene,

    	'conforto' => $conforto,

    	'entrega_resultados' => $entrega_resultados,

    	'satisfacao' => $satisfacao,

    	'recomenda' => $recomenda,

    	'data' => date('Y-m-d')

    ])->query();



    $Posto = $db->select('nome')->from('posto')->where("id_posto = $posto_id_posto")->query();



    //Enviar para o email

    $Mensagem = "

        Nova pesquisa preenchida! <br/>

        Data: ".date('d/m/Y')." <br/>

        <b>Posto</b>: ".utf8_decode($Posto[0]['nome'])." <br/> <br/>

        Acesso e Localização: ".$acesso_localizacao." <br/>

        Estacionamento: ".$estacionamento." <br/>

        Atendimento telefônico: ".$atendimento_telefonico." <br/>

        Atendimento recepção: ".$atendimento_recepcao." <br/>

        Atendimento coleta: ".$atendimento_coleta." <br/>

        Higiene: ".$higiene." <br/>

        Conforto: ".$conforto." <br/>

        Entrega de resultados: ".$entrega_resultados." <br/> <br/>

        Satisfação geral: ".getSatisfacao($satisfacao)." <br/>

        Recomendaria: ".getRecomenda($recomenda)."

    ";



    enviarEmail("Robô da Enquete", EMAIL_ADMIN, "Nova pesquisa preenchida", $Mensagem);



    $app->redirect(URL."/obrigado/$posto_id_posto");

});



//Página de filtros

$app->get('/gerar-relatorio', function() use($twig, $db) {

    $todosPostos = $db->select('*')->from('posto')->query();

    $InicioMes = date('d/m/Y', mktime(0, 0, 0, date('m') , 1 , date('Y')));

    $FimMes = date('d/m/Y', mktime(23, 59, 59, date('m'), date("t"), date('Y')));



    renderizarView($twig, ['titulo' => 'Gerar relatório', 'Postos' => $todosPostos, 'DataPadrao' => [$InicioMes, $FimMes], 'viewport' => true], 'filtros');

});



//Página dos relatórios

$app->post('/relatorios', function() use($twig, $db) {

    extract($_POST);

    

    $Datas = explode(' - ', $periodo);

    $Data_Inicio = gravaData($Datas[0]); $Data_Fim = gravaData($Datas[1]);



    if (!isset($postos)) {

        $postos = $db->select('id_posto')->from('posto')->query();

        

        $listaPostos = [];

        foreach ($postos as $posto) {

            $listaPostos[] = $posto['id_posto'];

        }



        $postos = implode(',', $listaPostos);

    } else {

        $postos = implode(',', array_map('intval', $postos));

    }

    

    renderizarView($twig, ['titulo' => 'Relatórios e gráficos', 'Filtros' => ['DataInicio' => $Data_Inicio, 'DataFim' => $Data_Fim , 'Postos' => $postos], 'viewport' => true], 'relatorios');

});



/* Requisições para os relatórios */



//Requisição de Avaliação dos serviços

$app->get('/requisitar-avaliacao-servicos/:DataInicio/:DataFim/:Postos', function($DataInicio, $DataFim, $Postos) use($twig, $db) {

    $rPostos = $db->select('*')->from('enquete')->where("data BETWEEN ('$DataInicio') AND ('$DataFim') AND posto_id_posto in ($Postos) ")->query();

    

    /* AVALIAÇÃO DE SERVIÇOS */



        //Criando variáveis para a média da avaliação de serviços

        $mAcesso = 0;

        $mEstacionamento = 0;

        $mAtendimentoTelefonico = 0;

        $mAtendimentoRecepcao = 0;

        $mAtendimentoColeta = 0;

        $mHigiene = 0;

        $mConforto = 0;

        $mEntregaResultados = 0;



        //Calculando o valor total das notas de cada pergunta

        foreach ($rPostos as $Posto) {

            $mAcesso += $Posto['acesso_localizacao'];

            $mEstacionamento  += $Posto['estacionamento'];

            $mAtendimentoTelefonico  += $Posto['atendimento_telefonico'];

            $mAtendimentoRecepcao  += $Posto['atendimento_recepcao'];

            $mAtendimentoColeta += $Posto['atendimento_coleta'];

            $mHigiene  += $Posto['higiene'];

            $mConforto  += $Posto['conforto'];

            $mEntregaResultados += $Posto['entrega_resultados'];

        }



        //Calculando a média

        $tReg = count($rPostos); //Número de postos



        $rArray_Avaliacao = [

            'labels' => [

                "Acesso e Localização", 

                "Estacionamento", 

                "Atendimento Telefônico", 

                "Atendimento na Recepção", 

                "Atendimento na Coleta",  

                "Higiene e Limpeza", 

                "Conforto das Instalações", 

                "Entrega de resultados"

            ],

            'datasets' => [[

                'label' => ['# Média'],

                'data' => [

                    $mAcesso, 

                    $mEstacionamento, 

                    $mAtendimentoTelefonico, 

                    $mAtendimentoRecepcao, 

                    $mAtendimentoColeta, 

                    $mHigiene, 

                    $mConforto, 

                    $mEntregaResultados

                ],

                'backgroundColor' => [

                    randomColor(),

                    randomColor(),

                    randomColor(),

                    randomColor(),

                    randomColor(),

                    randomColor(),

                    randomColor(),

                    randomColor()

                ]

            ]]

        ];



        echo json_encode($rArray_Avaliacao);

        

    /* FIM DA AVALIAÇÃO DE SERVIÇOS */ 

});



//Requisição de Avaliação da satisfação

$app->get('/requisitar-satisfacao-geral/:DataInicio/:DataFim/:Postos', function($DataInicio, $DataFim, $Postos) use($twig, $db) {

    $rSatisfacao = $db->query("SELECT satisfacao, posto_id_posto, count(*) as total FROM enquete WHERE data BETWEEN ('$DataInicio') AND ('$DataFim') AND satisfacao in (2, 3, 4) AND posto_id_posto in ($Postos) group by satisfacao");

    

    /* SATISFAÇÃO GERAL */



        $Insatisfeito = 0;

        $Regular = 0;

        $Satisfeito = 0;

        foreach ($rSatisfacao as $Satisfacao) {

            if ($Satisfacao['satisfacao'] == 2) {

                $Insatisfeito = $Satisfacao['total'];

            }

            if ($Satisfacao['satisfacao'] == 3) {

                $Regular = $Satisfacao['total'];

            }

            if ($Satisfacao['satisfacao'] == 4) {

                $Satisfeito = $Satisfacao['total'];

            }

        }



        $rArray_Satisfacao = [

            'labels' => [

                "Insatisfeito", 

                "Regular", 

                "Satisfeito"

            ],

            'datasets' => [[

                'data' => [

                    $Insatisfeito,

                    $Regular,

                    $Satisfeito

                ],

                'backgroundColor' => [

                    randomColor(),

                    randomColor(),

                    randomColor()

                ]

            ]]

        ];



        echo json_encode($rArray_Satisfacao);



    /* FIM DA SATISFAÇÃO GERAL */ 

});



//Requisição de comparação dos postos

$app->get('/requisitar-recomendaria/:DataInicio/:DataFim/:Postos', function($DataInicio, $DataFim, $Postos) use($twig, $db) {

    $rRecomenda = $db->query("SELECT recomenda, posto_id_posto, count(*) as total FROM enquete WHERE data BETWEEN ('$DataInicio') AND ('$DataFim') AND satisfacao in (2, 3, 4) AND posto_id_posto in ($Postos) group by recomenda, posto_id_posto");

    

    /* RECOMENDARIA */



        $Sim = 0;

        $Nao = 0;

        foreach ($rRecomenda as $Recomenda) {

            if ($Recomenda['recomenda'] == 0) {

                $Nao += $Recomenda['total'];

            } 

            if ($Recomenda['recomenda'] == 1) {

                $Sim += $Recomenda['total'];

            }

        }



        $rArray_Recomenda = [

            'labels' => [

                "Recomendaria", 

                "Não recomendaria"

            ],

            'datasets' => [[

                'label' => ['Total'],

                'data' => [

                    $Sim,

                    $Nao

                ],

                'backgroundColor' => [

                    randomColor(),

                    randomColor()

                ]

            ]]

        ];



        echo json_encode($rArray_Recomenda);



    /* FIM DA RECOMENDAÇÃO */ 

});



//Requisição de comparação por periodo

$app->get('/requisitar-media-periodo/:DataInicio/:DataFim/:Postos', function($DataInicio, $DataFim, $Postos) use($twig, $db) {

    

    /* PESQUISA POR PERIODO */



        $currentDate = strtotime($DataFim);

        $Meses = [];

        while ($currentDate >= strtotime($DataInicio)) {

            $Meses[] = date('m',$currentDate);

            $currentDate = strtotime( date('Y/m/01/',$currentDate).' -1 month');

        }



        $Meses = implode(',', $Meses);



        $rRecomenda = $db->query("

            SELECT AVG(DISTINCT estacionamento) as mEstacionamento, 

            AVG(DISTINCT acesso_localizacao) as mAcesso, 

            AVG(DISTINCT atendimento_telefonico) as mAtendimentoTelefonico,

            AVG(DISTINCT atendimento_recepcao) as mAtendimentoRecepcao, 

            AVG(DISTINCT atendimento_coleta) as mAtendimentoColeta, 

            AVG(DISTINCT higiene) as mHigiene,

            AVG(DISTINCT conforto) as mConforto, 

            AVG(DISTINCT entrega_resultados) as mEntrega, data

            FROM enquete WHERE data BETWEEN ('$DataInicio') AND ('$DataFim') AND posto_id_posto in ($Postos)

            group by MONTH(data)

        ");



        $rArray_Periodo = [

            'datasets' => [[

                'label' => ['Média geral'],

            ]]

        ];



        $Meses = [];

        foreach ($rRecomenda as $key => $Recomedacao) {

            

            $mGeral = (

                $Recomedacao['mEstacionamento'] + 

                $Recomedacao['mAcesso'] + 

                $Recomedacao['mAtendimentoTelefonico'] + 

                $Recomedacao['mAtendimentoRecepcao'] + 

                $Recomedacao['mAtendimentoColeta'] + 

                $Recomedacao['mHigiene'] + 

                $Recomedacao['mConforto'] + 

                $Recomedacao['mEntrega']

            ) / 8;



            $rArray_Periodo['labels'][] = [

                getMes($Recomedacao['data'])

            ];



            $rArray_Periodo['datasets'][0]['data'][] = [

                round($mGeral, 2)

            ];



            $rArray_Periodo['datasets'][0]['backgroundColor'][] = [

                randomColor()

            ];            

        }



       echo json_encode($rArray_Periodo);



    /* FIM DA PESQUISA POR PERIODO */ 

});



//Requisição para exportar em XLS

$app->get('/requisitar-xls/:DataInicio/:DataFim/:Postos', function($DataInicio, $DataFim, $Postos) use($twig, $db) {

    

    $rEnquete = $db->select('*')->from('enquete')->innerJoin('posto', 'posto.id_posto = enquete.posto_id_posto')->where("data BETWEEN ('$DataInicio') AND ('$DataFim') AND posto_id_posto in ($Postos) ")->orderByASC(['posto.id_posto'])->query();



    $dataXLS = [];

    foreach ($rEnquete as $Enquete) {

        $dataXLS[] = [

            utf8_decode("Data") => retornaData($Enquete['data']),

            utf8_decode("Posto") => utf8_decode($Enquete['nome']),

            utf8_decode("Acesso e Localização") => $Enquete['acesso_localizacao'],

            utf8_decode("Estacionamento") => $Enquete['estacionamento'],

            utf8_decode("Atendimento Telefônico") => $Enquete['atendimento_telefonico'],

            utf8_decode("Atendimento na Recepção") => $Enquete['atendimento_recepcao'],

            utf8_decode("Atendimento na Coleta") => $Enquete['atendimento_coleta'],

            utf8_decode("Higiene e Limpeza") => $Enquete['higiene'],

            utf8_decode("Conforto das Instalações") => $Enquete['conforto'],

            utf8_decode("Entrega de resultados") => $Enquete['entrega_resultados'],

            utf8_decode("Nível de satisfação") => utf8_decode(getSatisfacao($Enquete['satisfacao'])),

            utf8_decode("Recomendaria") => utf8_decode(getRecomenda($Enquete['recomenda']))

        ];

    }



    $nomeArquivo = "Relacao_Notas_".date('dmY').".xls";



    header("Content-Disposition: attachment; filename=\"$nomeArquivo\"");

    header("Content-Type: application/vnd.ms-excel");

  

    $flag = false;

    foreach($dataXLS as $row) {

        if(!$flag) {

            // display column names as first row

            echo implode("\t", array_keys($row)) . "\n";

            $flag = true;

        }

        // filter data

        array_walk($row, 'filterData');

        echo implode("\t", array_values($row)) . "\n";



    }

    

    exit;

});