<?php



/*

 * This file is part of Twig.

 *

 * (c) Fabien Potencier

 * (c) Armin Ronacher

 *

 * For the full copyright and license information, please view the LICENSE

 * file that was distributed with this source code.

 */



/**

 * Represents a parent node.

 *

 * @author Fabien Potencier <fabien@symfony.com>

 */

class Twig_Node_Expression_Parent extends Twig_Node_Expression

{

    public function __construct($name, $lineno, $tag = null)

    {

        parent::__construct(array(), array('output' => false, 'name' => $name), $lineno, $tag);

    }



    public function compile(Twig_Compiler $compiler)

    {

        if ($this->getAttribute('output')) {

            $compiler

                ->addDebugInfo($this)

                ->write('$this->displayParentBlock(')

                ->string($this->getAttribute('name'))

                ->raw(", \$context, \$blocks);\n")

            ;

        } else {

            $compiler

                ->raw('$this->renderParentBlock(')

                ->string($this->getAttribute('name'))

                ->raw(', $context, $blocks)')

            ;

        }

    }

}



class_alias('Twig_Node_Expression_Parent', 'Twig\Node\Expression\ParentExpression', false);

